/** 
 * @preserve jQuery DateTimePicker plugin v1.0.1
 * (c) 2013, Chupurnov Valeriy.
 */
(function( $ ){
	$.fn.datetimepicker = function( opt ){
		var default_options  = {
			i18n:{
				ru:{
					months:[
						'Январь','Февраль','Март','Апрель','Май','Июнь','Июль','Август','Сентябрь','Октябрь','Ноябрь','Декабрь',
					],
					dayOfWeek:[
						"Вск", "Пн", "Вт", "Ср", "Чт", "Пт", "Сб",
					],
				},
				en:{
					months: [
						"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"
					],
					dayOfWeek: [
						"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat",
					],
				},
				de:{
					months:[
						'Januar','Februar','März','April','Mai','Juni','Juli','August','September','Oktober','November','Dezember',
					],
					dayOfWeek:[
						"So.", "Mo", "Di", "Mi", "Do", "Fr", "Sa.",
					],
				},
			},
			value:'',
			lang:'en',
			format:'Y-m-d H:i',
			formatTime:'H:i',
			formatDate:'Y/m/d',
			step:60,
			closeOnDateSelect:0,
			closeOnWithoutClick:true,
			timepicker:true,
			datepicker:true,
			minDate:false,
			maxDate:false,
			minTime:false,
			maxTime:false,
			allowTimes:[],
			opened:false,
			inline:false,
			onSelectDate:function(){},
			onSelectTime:function(){},
			onChangeMonth:function(){},
			onChangeTime:function(){},
			onShow:function(){},
			onClose:function(){},
			withoutCopyright:true,
			inverseButton:false,
			hours12:false,
			next:	'xdsoft_next',
			prev : 'xdsoft_prev',
			dayOfWeekStart:0,
			timeHeightInTimePicker:25,
		};
		var options = $.extend({},default_options,opt);
		var createDateTimePicker = function( input ){
			var datetimepicker = $('<div class="xdsoft_datetimepicker"></div>'),
				xdsoft_copyright = $('<div class="xdsoft_copyright"><a target="_blank" href="http://xdsoft.net/jqplugins/datetimepicker/">xdsoft.net</a></div>'),
				datepicker = $('<div class="xdsoft_datepicker active"></div>'),
				mounth_picker = $('<div class="xdsoft_mounthpicker"><button class="xdsoft_prev"></button><div class="xdsoft_label xdsoft_month"></div><div class="xdsoft_label xdsoft_year"></div><button class="xdsoft_next"></button></div>'),
				calendar = $('<div class="xdsoft_calendar"></div>'),
				timepicker = $('<div class="xdsoft_timepicker active"><button class="xdsoft_prev"></button><div class="xdsoft_titbl_box"></div><button class="xdsoft_next"></button></div>'),
				timebox = $('<div class="xdsoft_titbl_variant"></div>');
			datetimepicker.setOptions = function( _options ){
				options = $.extend({},options,_options);
				if( options.inline ){
					datetimepicker.addClass('xdsoft_inline');
					input.after(datetimepicker).hide();
				}
				if( options.open||options.opened||options.inline ){
					input.trigger('open.xdsoft');
				}
				if( options.inverseButton ){
					options.next = 'xdsoft_prev';
					options.prev = 'xdsoft_next';
				}
				if( !options.datepicker && options.timepicker )
					datepicker.removeClass('active');
				if( options.datepicker && !options.timepicker )
					timepicker.removeClass('active');
				if( options.value )
					input&&input.val&&input.val(options.value);
				if( isNaN(options.dayOfWeekStart)||parseInt(options.dayOfWeekStart)<0||parseInt(options.dayOfWeekStart)>6 )
					options.dayOfWeekStart = 0;
				else 
					options.dayOfWeekStart = parseInt(options.dayOfWeekStart);
				options.dayOfWeekStartPrev = (options.dayOfWeekStart==0)?6:options.dayOfWeekStart-1;
			};
			datetimepicker.data('options',options);
			datetimepicker.on('mousedown',function( event ){
				event.stopPropagation();
			});
			timepicker.find('.xdsoft_titbl_box').append(timebox);
			datetimepicker.append(datepicker).append(timepicker);
			if( options.withoutCopyright!==true )
				datetimepicker.append(xdsoft_copyright);
			datepicker.append(mounth_picker).append(calendar);
			$('body').append(datetimepicker);
			var xdsoft_datetime = function(){
				var self = this;
				self.now = function(){
					return new Date();
				};
				self.currentTime = this.now();
				self.isValidDate = function (d) {
					if ( Object.prototype.toString.call(d) !== "[object Date]" )
						return false;
					return !isNaN(d.getTime());
				};
				self.setCurrentTime = function( dTime){
					self.currentTime = (typeof dTime == 'string')? self.strtodatetime(dTime) : self.isValidDate(dTime) ? dTime: self.now();
					datetimepicker.trigger('change.xdsoft');
				};
				self.getCurrentTime = function( dTime){
					return self.currentTime;
				};
				self.nextMonth = function(){
					var month = self.currentTime.getMonth()+1;
					if( month==12 ){
						self.currentTime.setFullYear(self.currentTime.getFullYear()+1);
						month = 0;
					}
					self.currentTime.setMonth(month);
					options.onChangeMonth&&options.onChangeMonth.call&&options.onChangeMonth.call(datetimepicker,datetimepicker.data('xdsoft_datetime').currentTime,datetimepicker.data('input'));
					datetimepicker.trigger('change.xdsoft');
					return month;
				};
				self.prevMonth = function(){
					var month = self.currentTime.getMonth()-1;
					if( month==-1 ){
						self.currentTime.setFullYear(self.currentTime.getFullYear()-1);
						month = 11;
					}
					self.currentTime.setMonth(month);
					options.onChangeMonth&&options.onChangeMonth.call&&options.onChangeMonth.call(datetimepicker,datetimepicker.data('xdsoft_datetime').currentTime,datetimepicker.data('input'));
					datetimepicker.trigger('change.xdsoft');
					return month;
				};
				
				this.strtodatetime = function( sDateTime ){
					var currentTime = sDateTime?Date.parseDate(sDateTime, options.format):new Date;
					if( ! self.isValidDate(currentTime) )
						currentTime = new Date;
					return currentTime;
				};
				this.strtodate = function( sDate ){
					var currentTime = sDate?Date.parseDate(sDate, options.formatDate):new Date;
					if( !self.isValidDate(currentTime) )
						currentTime = new Date;
					return currentTime;
				};
				this.strtotime = function( sTime ){
					var currentTime = sTime?Date.parseDate(sTime, options.formatTime):new Date;
					if( ! self.isValidDate(currentTime) )
						currentTime = new Date;
					return currentTime;
				};
				this.str = function(){
					return this.currentTime.dateFormat(options.format);
				};	
			};
			mounth_picker.find('.xdsoft_prev,.xdsoft_next').mousedown(function(){
				var $this = $(this), timer = 0, stop = false;
				(function(v){
					var month =  datetimepicker.data('xdsoft_datetime').currentTime.getMonth();
					if( $this.hasClass( options.next ) ){
						datetimepicker.data('xdsoft_datetime').nextMonth();
					}else if( $this.hasClass( options.prev ) ){
						datetimepicker.data('xdsoft_datetime').prevMonth();
					}
					!stop&&(timer = setTimeout(arguments.callee,v?v:100));
				})(500);
				$(window).on('mouseup',function(){
					clearTimeout(timer);
					stop = true;
					$(this).off('mouseup',arguments.callee);
				});
			});
			timepicker.find('.xdsoft_prev,.xdsoft_next').mousedown(function(){
				var $this = $(this), timer = 0, stop = false, period = 110;
				(function(v){
					var pheight = timebox.parent()[0].offsetHeight,
					height = timebox[0].offsetHeight,
					top = Math.abs(parseInt(timebox.css('marginTop')));
					if( $this.hasClass(options.next) && (height-pheight)- options.timeHeightInTimePicker>=top ){
						timebox.css('marginTop','-'+(top+options.timeHeightInTimePicker)+'px')
					}else if( $this.hasClass(options.prev) && top-options.timeHeightInTimePicker>=0  ){
						timebox.css('marginTop','-'+(top-options.timeHeightInTimePicker)+'px')
					}
					options.onChangeTime&&options.onChangeTime.call&&options.onChangeTime.call(datetimepicker,datetimepicker.data('xdsoft_datetime').currentTime,datetimepicker.data('input'));
					period= ( period>10 )?10:period-10;
					!stop&&(timer = setTimeout(arguments.callee,v?v:period));
				})(500);
				$(window).on('mouseup',function(){
					clearTimeout(timer);
					stop = true;
					$(this).off('mouseup',arguments.callee);
				});
			});	
			datetimepicker.on('change.xdsoft',function(){
				var xd 		=	$(this).data('xdsoft_datetime'),
					table 	=	'';
				var start = new Date(xd.currentTime.getFullYear(),xd.currentTime.getMonth(),1);
				while( start.getDay()!=options.dayOfWeekStart )
					start.setDate(start.getDate()-1);
				var i = 0, today = new Date;
				table+='<table><thead><tr>';
				for(var j = 0; j<7; j++)
					table+='<th>'+options.i18n[options.lang].dayOfWeek[(j+options.dayOfWeekStart)>6?0:j+options.dayOfWeekStart]+'</th>';
				table+='</tr></thead>';
				table+='<tbody><tr>';
				while( i<xd.currentTime.getDaysInMonth()||start.getDay()!=options.dayOfWeekStart||xd.currentTime.getMonth()==start.getMonth() ){
					i++;
					table+='<td data-date="'+start.getDate()+'" data-month="'+start.getMonth()+'" data-year="'+start.getFullYear()+'"'+
						' class="'+
							(
								(options.maxDate!==false&&xd.strtodate(options.maxDate).getTime()<start.getTime())||
								(options.minDate!==false&&xd.strtodate(options.minDate).getTime()>start.getTime())
							?'xdsoft_disabled ':' ')+
							(xd.currentTime.getMonth()!=start.getMonth()?' xdsoft_other_month ':' ')+
							(xd.currentTime.dateFormat('d.m.Y')==start.dateFormat('d.m.Y')?' xdsoft_current ':' ')+
							(today.dateFormat('d.m.Y')==start.dateFormat('d.m.Y')?' xdsoft_today ':' ')
						+'"><div>'+start.getDate()+'</div></td>';
					if( start.getDay()==options.dayOfWeekStartPrev )
						table+='</tr>';
					start.setDate(start.getDate()+1);
				}
				table+='</tbody></table>';
				calendar.html(table);
				mounth_picker.find('.xdsoft_label').eq(0).text(options.i18n[options.lang].months[xd.currentTime.getMonth()]);
				mounth_picker.find('.xdsoft_label').eq(1).text(xd.currentTime.getFullYear());
				var time = '',h = '',m ='';
				var line_time = function (h,m){
					var now = new Date();
					now.setHours(h);
					h = parseInt(now.getHours());
					now.setMinutes(m);
					m = parseInt(now.getMinutes());
					time+= '<div class="'+
								(
									(options.maxTime!==false&&xd.strtotime(options.maxTime).getTime()<now.getTime())||
									(options.minTime!==false&&xd.strtotime(options.minTime).getTime()>now.getTime())
								?'xdsoft_disabled ':' ')+
								((parseInt(xd.currentTime.getHours())==parseInt(h)&&parseInt(xd.currentTime.getMinutes())==parseInt(m))?' xdsoft_current ':'')+
								((parseInt(today.getHours())==parseInt(h)&&parseInt(today.getMinutes())==parseInt(m))?' xdsoft_today ':'')+
								'" data-hour="'+h+'" data-minute="'+m+'">'+now.dateFormat(options.formatTime)+'</div>';
				};
				if( !options.allowTimes || !$.isArray(options.allowTimes) || !options.allowTimes.length ){
					for(var i=0;i<(options.hours12?12:24);i++){
						for(var j=0;j<60;j+=options.step){
							h = (i<10?'0':'')+i;
							m = (j<10?'0':'')+j;
							line_time(h,m);
						}
					}
				}else{
					for(var i=0;i<options.allowTimes.length;i++){
						h = xd.strtotime(options.allowTimes[i]).getHours();
						m = xd.strtotime(options.allowTimes[i]).getMinutes();
						line_time(h,m);
					}
				}
				timebox.html(time);
				//timebox.find('.xdsoft_current').length&&timebox.css('marginTop','-'+parseInt(timebox.find('.xdsoft_current').index()*options.timeHeightInTimePicker)+'px');
			});
			datetimepicker.on( 'open.doksoft',function(){
				if( timebox.find('.xdsoft_current').length ){
					var pheight = timebox.parent()[0].offsetHeight,
						height = timebox[0].offsetHeight,
						top = timebox.find('.xdsoft_current').index()*options.timeHeightInTimePicker;
					if( (height-pheight)<top )
						top = height-pheight;
					timebox.css('marginTop','-'+parseInt(top)+'px');
				}
			});
			calendar.on( 'mousedown','td',function(){
				if($(this).hasClass('xdsoft_disabled'))
					return false;
				var ct = datetimepicker.data('xdsoft_datetime').currentTime;
				ct.setFullYear($(this).data('year'));
				ct.setMonth($(this).data('month'));
				ct.setDate($(this).data('date'));
				datetimepicker.trigger('select.xdsoft',[ct]);
				input.val( datetimepicker.data('xdsoft_datetime').str() );
				if( (options.closeOnDateSelect===true||( options.closeOnDateSelect===0&&!options.timepicker ))&&!options.inline )
					datetimepicker.close();
				options.onSelectDate&&options.onSelectDate.call&&options.onSelectDate.call(datetimepicker,datetimepicker.data('xdsoft_datetime').currentTime,datetimepicker.data('input'));
				datetimepicker.trigger('change.xdsoft');
			});		
			timebox.on( 'mousedown','div',function(){
				if($(this).hasClass('xdsoft_disabled'))
					return false;
				var ct = datetimepicker.data('xdsoft_datetime').currentTime;
				ct.setHours($(this).data('hour'));
				ct.setMinutes($(this).data('minute'));
				datetimepicker.trigger('select.xdsoft',[ct]);
				datetimepicker.data('input').val( datetimepicker.data('xdsoft_datetime').str() );
				!options.inline&&datetimepicker.close();
				options.onSelectTime&&options.onSelectTime.call&&options.onSelectTime.call(datetimepicker,datetimepicker.data('xdsoft_datetime').currentTime,datetimepicker.data('input'));
				datetimepicker.trigger('change.xdsoft');
			});
			datetimepicker.mousewheel&&datepicker.mousewheel(function(event, delta, deltaX, deltaY) {
				if( delta<0 )
					datetimepicker.data('xdsoft_datetime').nextMonth();
				else
					datetimepicker.data('xdsoft_datetime').prevMonth();
				return false;
			});		
			datetimepicker.mousewheel&&timepicker.mousewheel(function(event, delta, deltaX, deltaY) {
				var pheight = timebox.parent()[0].offsetHeight,
					height = timebox[0].offsetHeight,
					top = Math.abs(parseInt(timebox.css('marginTop')));
				if( delta<0 && (height-pheight)-options.timeHeightInTimePicker>=top ){
					timebox.css('marginTop','-'+(top+options.timeHeightInTimePicker)+'px');
					return false;
				}else if( delta>0&&top-options.timeHeightInTimePicker>=0 ){
					timebox.css('marginTop','-'+(top-options.timeHeightInTimePicker)+'px');
					return false;
				}
				options.onChangeTime&&options.onChangeTime.call&&options.onChangeTime.call(datetimepicker,datetimepicker.data('xdsoft_datetime').currentTime,datetimepicker.data('input'));
			});
			var current_titbl_index = 0;
			input.mousewheel&&input.mousewheel(function( event, delta, deltaX, deltaY ){
				if( !options.datepicker && options.timepicker ){
					current_titbl_index = timebox.find('.xdsoft_current').length?timebox.find('.xdsoft_current').eq(0).index():0;
					if( current_titbl_index+delta>=0&&current_titbl_index+delta<timebox.children().length )
						current_titbl_index+=delta;
					timebox.children().eq(current_titbl_index).length&&timebox.children().eq(current_titbl_index).trigger('mousedown');
					return false;
				}else if( options.datepicker && !options.timepicker ){
					datepicker.trigger( event, [delta, deltaX, deltaY]);
					input.val&&input.val( datetimepicker.data('xdsoft_datetime').str() );
					return false;
				}
			});
			datetimepicker.open = function(){
				var onShow = true;
				options.onShow&&options.onShow.call&&(onShow=options.onShow.call(datetimepicker,datetimepicker.data('xdsoft_datetime').currentTime,datetimepicker.data('input')));
				if( onShow!==false ){
					var offset = datetimepicker.data('input').offset();
					datetimepicker.css({
						left:offset.left,
						top:offset.top+datetimepicker.data('input')[0].offsetHeight,
					}).show();
					datetimepicker.trigger('open.doksoft');
				}
			}; 
			datetimepicker.close = function(){
				var onClose = true;
				options.onClose&&options.onClose.call&&(onClose=options.onClose.call(datetimepicker,datetimepicker.data('xdsoft_datetime').currentTime,datetimepicker.data('input')));
				if( onClose!==false&&!options.opened&&!options.inline ){
					datetimepicker.hide();
				}
			};
			datetimepicker.data('input',input);
			
			var _xdsoft_datetime = new xdsoft_datetime,timer = 0;
			datetimepicker.data('xdsoft_datetime',_xdsoft_datetime);
			datetimepicker.setOptions(options);
			_xdsoft_datetime.setCurrentTime( options.value?options.value:(input&&input.val&&input.val())?input.val():new Date );
			input.data( 'xdsoft_datetimepicker',datetimepicker )
				.on('enter keyup mousedown open.xdsoft',function(event){
				if( input.is(':disabled')||input.is(':hidden')||!input.is(':visible') )
					return;
				clearTimeout(timer);
				timer = setTimeout(function(){
					if( input.is(':disabled')||input.is(':hidden')||!input.is(':visible') )
						return;
					_xdsoft_datetime.setCurrentTime((input&&input.val&&input.val())?input.val():new Date);
					datetimepicker.open();
					if( options.closeOnWithoutClick ){
						$(window).on('mousedown keydown',function(){
							datetimepicker.close();
							$(this).off('mousedown',arguments.callee);
						});
					}
				},100);
				//event.stopPropagation();
			});
			
			
		};
		return this.each(function(){
			if( $(this).data('xdsoft_datetimepicker') ){
				$(this).data('xdsoft_datetimepicker').setOptions(options);
				return 0;
			}
			createDateTimePicker($(this));
		});
	};
})( jQuery );

//http://www.xaprb.com/blog/2005/12/12/javascript-closures-for-runtime-efficiency/
/*
 * Copyright (C) 2004 Baron Schwartz <baron at sequent dot org>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation, version 2.1.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 */
Date.parseFunctions={count:0};Date.parseRegexes=[];Date.formatFunctions={count:0};Date.prototype.dateFormat=function(format){if(Date.formatFunctions[format]==null){Date.createNewFormat(format)}var func=Date.formatFunctions[format];return this[func]()};Date.createNewFormat=function(format){var funcName="format"+Date.formatFunctions.count++;Date.formatFunctions[format]=funcName;var code="Date.prototype."+funcName+" = function(){return ";var special=false;var ch='';for(var i=0;i<format.length;++i){ch=format.charAt(i);if(!special&&ch=="\\"){special=true}else if(special){special=false;code+="'"+String.escape(ch)+"' + "}else{code+=Date.getFormatCode(ch)}}eval(code.substring(0,code.length-3)+";}")};Date.getFormatCode=function(character){switch(character){case"d":return"String.leftPad(this.getDate(), 2, '0') + ";case"D":return"Date.dayNames[this.getDay()].substring(0, 3) + ";case"j":return"this.getDate() + ";case"l":return"Date.dayNames[this.getDay()] + ";case"S":return"this.getSuffix() + ";case"w":return"this.getDay() + ";case"z":return"this.getDayOfYear() + ";case"W":return"this.getWeekOfYear() + ";case"F":return"Date.monthNames[this.getMonth()] + ";case"m":return"String.leftPad(this.getMonth() + 1, 2, '0') + ";case"M":return"Date.monthNames[this.getMonth()].substring(0, 3) + ";case"n":return"(this.getMonth() + 1) + ";case"t":return"this.getDaysInMonth() + ";case"L":return"(this.isLeapYear() ? 1 : 0) + ";case"Y":return"this.getFullYear() + ";case"y":return"('' + this.getFullYear()).substring(2, 4) + ";case"a":return"(this.getHours() < 12 ? 'am' : 'pm') + ";case"A":return"(this.getHours() < 12 ? 'AM' : 'PM') + ";case"g":return"((this.getHours() %12) ? this.getHours() % 12 : 12) + ";case"G":return"this.getHours() + ";case"h":return"String.leftPad((this.getHours() %12) ? this.getHours() % 12 : 12, 2, '0') + ";case"H":return"String.leftPad(this.getHours(), 2, '0') + ";case"i":return"String.leftPad(this.getMinutes(), 2, '0') + ";case"s":return"String.leftPad(this.getSeconds(), 2, '0') + ";case"O":return"this.getGMTOffset() + ";case"T":return"this.getTimezone() + ";case"Z":return"(this.getTimezoneOffset() * -60) + ";default:return"'"+String.escape(character)+"' + "}};Date.parseDate=function(input,format){if(Date.parseFunctions[format]==null){Date.createParser(format)}var func=Date.parseFunctions[format];return Date[func](input)};Date.createParser=function(format){var funcName="parse"+Date.parseFunctions.count++;var regexNum=Date.parseRegexes.length;var currentGroup=1;Date.parseFunctions[format]=funcName;var code="Date."+funcName+" = function(input){\n"+"var y = -1, m = -1, d = -1, h = -1, i = -1, s = -1;\n"+"var d = new Date();\n"+"y = d.getFullYear();\n"+"m = d.getMonth();\n"+"d = d.getDate();\n"+"var results = input.match(Date.parseRegexes["+regexNum+"]);\n"+"if (results && results.length > 0) {";var regex="";var special=false;var ch='';for(var i=0;i<format.length;++i){ch=format.charAt(i);if(!special&&ch=="\\"){special=true}else if(special){special=false;regex+=String.escape(ch)}else{obj=Date.formatCodeToRegex(ch,currentGroup);currentGroup+=obj.g;regex+=obj.s;if(obj.g&&obj.c){code+=obj.c}}}code+="if (y > 0 && m >= 0 && d > 0 && h >= 0 && i >= 0 && s >= 0)\n"+"{return new Date(y, m, d, h, i, s);}\n"+"else if (y > 0 && m >= 0 && d > 0 && h >= 0 && i >= 0)\n"+"{return new Date(y, m, d, h, i);}\n"+"else if (y > 0 && m >= 0 && d > 0 && h >= 0)\n"+"{return new Date(y, m, d, h);}\n"+"else if (y > 0 && m >= 0 && d > 0)\n"+"{return new Date(y, m, d);}\n"+"else if (y > 0 && m >= 0)\n"+"{return new Date(y, m);}\n"+"else if (y > 0)\n"+"{return new Date(y);}\n"+"}return null;}";Date.parseRegexes[regexNum]=new RegExp("^"+regex+"$");eval(code)};Date.formatCodeToRegex=function(character,currentGroup){switch(character){case"D":return{g:0,c:null,s:"(?:Sun|Mon|Tue|Wed|Thu|Fri|Sat)"};case"j":case"d":return{g:1,c:"d = parseInt(results["+currentGroup+"], 10);\n",s:"(\\d{1,2})"};case"l":return{g:0,c:null,s:"(?:"+Date.dayNames.join("|")+")"};case"S":return{g:0,c:null,s:"(?:st|nd|rd|th)"};case"w":return{g:0,c:null,s:"\\d"};case"z":return{g:0,c:null,s:"(?:\\d{1,3})"};case"W":return{g:0,c:null,s:"(?:\\d{2})"};case"F":return{g:1,c:"m = parseInt(Date.monthNumbers[results["+currentGroup+"].substring(0, 3)], 10);\n",s:"("+Date.monthNames.join("|")+")"};case"M":return{g:1,c:"m = parseInt(Date.monthNumbers[results["+currentGroup+"]], 10);\n",s:"(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)"};case"n":case"m":return{g:1,c:"m = parseInt(results["+currentGroup+"], 10) - 1;\n",s:"(\\d{1,2})"};case"t":return{g:0,c:null,s:"\\d{1,2}"};case"L":return{g:0,c:null,s:"(?:1|0)"};case"Y":return{g:1,c:"y = parseInt(results["+currentGroup+"], 10);\n",s:"(\\d{4})"};case"y":return{g:1,c:"var ty = parseInt(results["+currentGroup+"], 10);\n"+"y = ty > Date.y2kYear ? 1900 + ty : 2000 + ty;\n",s:"(\\d{1,2})"};case"a":return{g:1,c:"if (results["+currentGroup+"] == 'am') {\n"+"if (h == 12) { h = 0; }\n"+"} else { if (h < 12) { h += 12; }}",s:"(am|pm)"};case"A":return{g:1,c:"if (results["+currentGroup+"] == 'AM') {\n"+"if (h == 12) { h = 0; }\n"+"} else { if (h < 12) { h += 12; }}",s:"(AM|PM)"};case"g":case"G":case"h":case"H":return{g:1,c:"h = parseInt(results["+currentGroup+"], 10);\n",s:"(\\d{1,2})"};case"i":return{g:1,c:"i = parseInt(results["+currentGroup+"], 10);\n",s:"(\\d{2})"};case"s":return{g:1,c:"s = parseInt(results["+currentGroup+"], 10);\n",s:"(\\d{2})"};case"O":return{g:0,c:null,s:"[+-]\\d{4}"};case"T":return{g:0,c:null,s:"[A-Z]{3}"};case"Z":return{g:0,c:null,s:"[+-]\\d{1,5}"};default:return{g:0,c:null,s:String.escape(character)}}};Date.prototype.getTimezone=function(){return this.toString().replace(/^.*? ([A-Z]{3}) [0-9]{4}.*$/,"$1").replace(/^.*?\(([A-Z])[a-z]+ ([A-Z])[a-z]+ ([A-Z])[a-z]+\)$/,"$1$2$3")};Date.prototype.getGMTOffset=function(){return(this.getTimezoneOffset()>0?"-":"+")+String.leftPad(Math.floor(this.getTimezoneOffset()/60),2,"0")+String.leftPad(this.getTimezoneOffset()%60,2,"0")};Date.prototype.getDayOfYear=function(){var num=0;Date.daysInMonth[1]=this.isLeapYear()?29:28;for(var i=0;i<this.getMonth();++i){num+=Date.daysInMonth[i]}return num+this.getDate()-1};Date.prototype.getWeekOfYear=function(){var now=this.getDayOfYear()+(4-this.getDay());var jan1=new Date(this.getFullYear(),0,1);var then=(7-jan1.getDay()+4);document.write(then);return String.leftPad(((now-then)/7)+1,2,"0")};Date.prototype.isLeapYear=function(){var year=this.getFullYear();return((year&3)==0&&(year%100||(year%400==0&&year)))};Date.prototype.getFirstDayOfMonth=function(){var day=(this.getDay()-(this.getDate()-1))%7;return(day<0)?(day+7):day};Date.prototype.getLastDayOfMonth=function(){var day=(this.getDay()+(Date.daysInMonth[this.getMonth()]-this.getDate()))%7;return(day<0)?(day+7):day};Date.prototype.getDaysInMonth=function(){Date.daysInMonth[1]=this.isLeapYear()?29:28;return Date.daysInMonth[this.getMonth()]};Date.prototype.getSuffix=function(){switch(this.getDate()){case 1:case 21:case 31:return"st";case 2:case 22:return"nd";case 3:case 23:return"rd";default:return"th"}};String.escape=function(string){return string.replace(/('|\\)/g,"\\$1")};String.leftPad=function(val,size,ch){var result=new String(val);if(ch==null){ch=" "}while(result.length<size){result=ch+result}return result};Date.daysInMonth=[31,28,31,30,31,30,31,31,30,31,30,31];Date.monthNames=["January","February","March","April","May","June","July","August","September","October","November","December"];Date.dayNames=["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"];Date.y2kYear=50;Date.monthNumbers={Jan:0,Feb:1,Mar:2,Apr:3,May:4,Jun:5,Jul:6,Aug:7,Sep:8,Oct:9,Nov:10,Dec:11};Date.patterns={ISO8601LongPattern:"Y-m-d H:i:s",ISO8601ShortPattern:"Y-m-d",ShortDatePattern:"n/j/Y",LongDatePattern:"l, F d, Y",FullDateTimePattern:"l, F d, Y g:i:s A",MonthDayPattern:"F d",ShortTimePattern:"g:i A",LongTimePattern:"g:i:s A",SortableDateTimePattern:"Y-m-d\\TH:i:s",UniversalSortableDateTimePattern:"Y-m-d H:i:sO",YearMonthPattern:"F, Y"};

//https://github.com/brandonaaron/jquery-mousewheel/blob/master/jquery.mousewheel.js
/*
 * Copyright (c) 2013 Brandon Aaron (http://brandonaaron.net)
 *
 * Licensed under the MIT License (LICENSE.txt).
 *
 * Thanks to: http://adomas.org/javascript-mouse-wheel/ for some pointers.
 * Thanks to: Mathias Bank(http://www.mathias-bank.de) for a scope bug fix.
 * Thanks to: Seamus Leahy for adding deltaX and deltaY
 *
 * Version: 3.1.3
 *
 * Requires: 1.2.2+
 */
(function(factory){if(typeof define==='function'&&define.amd){define(['jquery'],factory)}else if(typeof exports==='object'){module.exports=factory}else{factory(jQuery)}}(function($){var toFix=['wheel','mousewheel','DOMMouseScroll','MozMousePixelScroll'];var toBind='onwheel'in document||document.documentMode>=9?['wheel']:['mousewheel','DomMouseScroll','MozMousePixelScroll'];var lowestDelta,lowestDeltaXY;if($.event.fixHooks){for(var i=toFix.length;i;){$.event.fixHooks[toFix[--i]]=$.event.mouseHooks}}$.event.special.mousewheel={setup:function(){if(this.addEventListener){for(var i=toBind.length;i;){this.addEventListener(toBind[--i],handler,false)}}else{this.onmousewheel=handler}},teardown:function(){if(this.removeEventListener){for(var i=toBind.length;i;){this.removeEventListener(toBind[--i],handler,false)}}else{this.onmousewheel=null}}};$.fn.extend({mousewheel:function(fn){return fn?this.bind("mousewheel",fn):this.trigger("mousewheel")},unmousewheel:function(fn){return this.unbind("mousewheel",fn)}});function handler(event){var orgEvent=event||window.event,args=[].slice.call(arguments,1),delta=0,deltaX=0,deltaY=0,absDelta=0,absDeltaXY=0,fn;event=$.event.fix(orgEvent);event.type="mousewheel";if(orgEvent.wheelDelta){delta=orgEvent.wheelDelta}if(orgEvent.detail){delta=orgEvent.detail*-1}if(orgEvent.deltaY){deltaY=orgEvent.deltaY*-1;delta=deltaY}if(orgEvent.deltaX){deltaX=orgEvent.deltaX;delta=deltaX*-1}if(orgEvent.wheelDeltaY!==undefined){deltaY=orgEvent.wheelDeltaY}if(orgEvent.wheelDeltaX!==undefined){deltaX=orgEvent.wheelDeltaX*-1}absDelta=Math.abs(delta);if(!lowestDelta||absDelta<lowestDelta){lowestDelta=absDelta}absDeltaXY=Math.max(Math.abs(deltaY),Math.abs(deltaX));if(!lowestDeltaXY||absDeltaXY<lowestDeltaXY){lowestDeltaXY=absDeltaXY}fn=delta>0?'floor':'ceil';delta=Math[fn](delta/lowestDelta);deltaX=Math[fn](deltaX/lowestDeltaXY);deltaY=Math[fn](deltaY/lowestDeltaXY);args.unshift(event,delta,deltaX,deltaY);return($.event.dispatch||$.event.handle).apply(this,args)}}));
